/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util.standalone;

import com.ibm.hwmca.fw.connmgr.Connection;
import com.ibm.hwmca.fw.connmgr.ConnectionGroup;
import com.ibm.hwmca.fw.tasklet.xport.stream.TaskletConnectionHandler;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.UUID;
import com.ibm.hwmca.fw.util.UUIDFactory;
import com.ibm.hwmca.fw.util.standalone.StandaloneConnection;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;

public class StandaloneConnectionFactory {
    private static final String TRACE_MASKT = "XFRMSTAT";
    private static final String TRACE_MASKF = "XFRMSTAF";
    private static final String TRACE_MASKD = "XFRMSTAD";
    private static int serverPort = 0;
    private static HashMap groupMap = new HashMap();

    public static ConnectionGroup getClientConnections() {
        Trace.trace(TRACE_MASKF, "-> StandaloneConnectionFactory.getClientConnections()");
        ConnectionGroup group = null;
        try {
            UUID uuid = UUIDFactory.generate(4);
            group = new ConnectionGroup(uuid, 2);
            int i = 0;
            while (i < 2) {
                Socket s = new Socket(InetAddress.getByName("127.0.0.1"), serverPort);
                ObjectOutputStream oos = new ObjectOutputStream(s.getOutputStream());
                oos.writeObject(uuid);
                oos.flush();
                StandaloneConnection connection = new StandaloneConnection(s, true);
                group.add(connection);
                ++i;
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, e);
        }
        Trace.trace(TRACE_MASKF, "<- StandaloneConnectionFactory.getClientConnections()");
        return group;
    }

    public static void startServer() {
        Trace.trace(TRACE_MASKF, "-> StandaloneConnectionFactory.startServer()");
        try {
            ServerSocket s = new ServerSocket(0, 1, InetAddress.getByName("127.0.0.1"));
            serverPort = s.getLocalPort();
            new Thread(new ServerThread(s)).start();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, e);
        }
        Trace.trace(TRACE_MASKF, "<- StandaloneConnectionFactory.startServer()");
    }

    private static class ServerThread
    implements Runnable {
        private ServerSocket s;

        private ServerThread(ServerSocket s) {
            this.s = s;
        }

        public void run() {
            Trace.trace(StandaloneConnectionFactory.TRACE_MASKF, "-> StandaloneConnectionFactory.ServerThread.run()");
            try {
                boolean done = false;
                while (!done) {
                    Trace.trace(StandaloneConnectionFactory.TRACE_MASKF, "waiting for connections...");
                    Socket clientSocket = this.s.accept();
                    ObjectInputStream ois = new ObjectInputStream(clientSocket.getInputStream());
                    UUID uuid = (UUID)ois.readObject();
                    Trace.trace(StandaloneConnectionFactory.TRACE_MASKF, "UUID of request is: " + uuid);
                    ConnectionGroup group = (ConnectionGroup)groupMap.get(uuid);
                    if (group == null) {
                        Trace.trace(StandaloneConnectionFactory.TRACE_MASKF, "creating new connection group...");
                        group = new ConnectionGroup(uuid, 2);
                        groupMap.put(uuid, group);
                    }
                    StandaloneConnection connection = new StandaloneConnection(clientSocket, false);
                    group.add(connection);
                    Trace.trace(StandaloneConnectionFactory.TRACE_MASKF, "new connection added to the group...");
                    Connection[] connections = group.getConnections();
                    int count = 0;
                    int i = 0;
                    while (i < connections.length) {
                        if (connections[i] != null) {
                            ++count;
                        }
                        ++i;
                    }
                    if (count != connections.length) continue;
                    Trace.trace(StandaloneConnectionFactory.TRACE_MASKF, "connection group is full; giving it to tasklets...");
                    final ConnectionGroup theGroup = group;
                    Thread handlerThread = new Thread("StandaloneConnection handler thread"){

                        public void run() {
                            Trace.trace(StandaloneConnectionFactory.TRACE_MASKF, "-> StandaloneConnection handler thread.run()");
                            try {
                                TaskletConnectionHandler handler = new TaskletConnectionHandler();
                                handler.handleAuthenticated(theGroup, (Serializable)((Object)""));
                            }
                            catch (Exception e) {
                                Trace.trace(StandaloneConnectionFactory.TRACE_MASKF, "StandaloneConnection handler thread caught exception");
                                Trace.trace(StandaloneConnectionFactory.TRACE_MASKF, e);
                            }
                            Trace.trace(StandaloneConnectionFactory.TRACE_MASKF, "<- StandaloneConnection handler thread.run()");
                        }
                    };
                    handlerThread.setDaemon(true);
                    handlerThread.start();
                }
            }
            catch (Exception e) {
                Trace.trace(StandaloneConnectionFactory.TRACE_MASKF, e);
            }
            Trace.trace(StandaloneConnectionFactory.TRACE_MASKF, "<- StandaloneConnectionFactory.ServerThread.run()");
        }
    }
}

